<body class="lang-en">
    <div id="userNotifications">
</div>


<script>
    function getCookieValue(name) {
        try {
            name = name.toLowerCase();
            var rawCookieString = document.cookie;

            var parts = rawCookieString.split(';');

            for (var i = 0; i < parts.length; i++) {
                var p = parts[i].split('=');

                if (p.length === 2) {
                    var key = p[0].trim().toLowerCase();
                    var value = p[1].trim();

                    if (key === name) {
                        return value;
                    }
                }
            }
        } catch (e) {

        }

        return null;
    }


    function isMobileAdSite() {
        if (navigator.connection && navigator.connection.effectiveType) {
            if (navigator.connection.effectiveType === '4g') {
                satConnectionType = 'fast';
                return false;
            } else {
                satConnectionType = 'slow';
                return true;
            }
        }
        return false;
    }

    

    function handleUserNotifications() {
        const encoded = window.sessionStorage.getItem('__SESSION_STORAGE_USER__');

        if (encoded === null) {
            return;
        }

        /** @type {MeData} */
        const storageUser = JSON.parse(encoded);

        if (!Array.isArray(storageUser?.roles)) {
            return;
        }

        const shouldHideEduClaimBanner = window.sat.project_name === 'API2Convert' || getCookieValue('user-edu-claim-banner-dismiss');

                if (
            !shouldHideEduClaimBanner &&
            storageUser.enabled &&
            storageUser.roles.includes('ROLE_USER_ELIGIBLE_FOR_EDUCATIONAL') &&
            !storageUser.roles.includes('ROLE_USER_EDUCATIONAL') &&
            !storageUser.roles.includes('ROLE_USER_NEEDS_VERIFICATION_FOR_EDUCATIONAL')
        ) {
            const eduEl = document.getElementById('user-edu-banner');

            if (eduEl !== null) {
                eduEl.classList.remove('d-none');
            }
        }
    }

    try {
        handleUserNotifications();
    } catch (e) {}
</script>
